﻿Imports System.IO
Imports System.Xml.Serialization

Public Class SerializableData

    'Metoda Save - serializuje obiekt na dysk.
    Public Sub Save(ByVal filename As String)
        'Tworzenie tymczasowej nazwy pliku.
        Dim tempFilename As String
        tempFilename = filename & ".tmp"
        'Czy plik istnieje?
        Dim tempFileInfo As New FileInfo(tempFilename)
        If tempFileInfo.Exists = True Then tempFileInfo.Delete()
        'Otwarcie pliku.
        Dim stream As New FileStream(tempFilename, FileMode.Create)
        'Zapisanie obiektu.
        Save(stream)
        'Zamknięcie pliku.
        stream.Close()
        'Usunięcie istniejącego pliku z danymi i
        'zmiana nazwy pliku tymczasowego.
        tempFileInfo.CopyTo(filename, True)
        tempFileInfo.Delete()
    End Sub

    'Metoda Save - odpowiada za samą serializację.
    Public Sub Save(ByVal stream As Stream)
        'Tworzenie obiektu XmlSerializer.
        Dim serializer As New XmlSerializer(Me.GetType)
        'Zapis pliku.
        serializer.Serialize(stream, Me)
    End Sub

    'Metoda Load - deserializacja z dysku.
    Public Shared Function Load(ByVal filename As String, _
       ByVal newType As Type) As Object
        'Czy plik istnieje?
        Dim fileInfo As New FileInfo(filename)
        If fileInfo.Exists = False Then
            'Utworzenie pustego obiektu i zwrócenie go.
            Return System.Activator.CreateInstance(newType)
        End If
        'Otwarcie pliku.
        Dim stream As New FileStream(filename, FileMode.Open)
        'Wczytanie obiektu ze strumienia.
        Dim newObject As Object = Load(stream, newType)
        'Zamknięcie strumienia.
        stream.Close()
        'Zwrócenie obiektu.
        Return newObject
    End Function

    'Metoda Load – przeprowadzanie deserializacji.
    Public Shared Function Load(ByVal stream As Stream, _
       ByVal newType As Type) As Object
        'Utworzenie obiektu XmlSerializer i wczytanie obiektu.
        Dim serializer As New XmlSerializer(newType)
        Dim newObject As Object = serializer.Deserialize(stream)
        'Zwrócenie nowego obiektu.
        Return newObject
    End Function

End Class
